<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="allClasses-frame">

	<html>
	<head>
	<xsl:call-template name="ImportCSS"/>
	<title>
	<xsl:value-of select="$title_param"></xsl:value-of>
	</title>
	<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>

	<!--script language="JavaScript">
		function doClick(imageHref) {
		if (parent.imageFrame != null)
		   parent.imageFrame.location.href = imageHref;
		}
	</script-->
	<xsl:call-template name="ImgLoaderScript"/>
	</head>
	<body>
	
	<!-- All diagrams -->
	<xsl:variable name="diagrams" select="//Diagram"></xsl:variable>
	<xsl:if test="$diagrams">
		<a name="allDiagrams"></a>
		<font size="+1" class="FrameHeadingFont">
		<b>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'all_diagrams'"></xsl:with-param>
		</xsl:call-template>
		</b>
		</font>
		<br/>
		<table border="0" width="100%">
		<tr>
		<td nowrap="nowrap">
		<font class="FrameItemFont">
		
		<xsl:call-template name="printDiagramList">
			<xsl:with-param name="diagrams" select="$diagrams"></xsl:with-param>
		</xsl:call-template>
			
		</font>
		</td>
		</tr>
		</table>
		<p/>
	</xsl:if>
	
	<!-- All classes  -->
	<xsl:variable name="classes" select="//Classifier"></xsl:variable>
	<xsl:if test="$classes">
		<a name="allClasses"></a>
		<font size="+1" class="FrameHeadingFont">
		<b>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'all_classes'"></xsl:with-param>
		</xsl:call-template>
		</b>
		</font>
		<br/>
		<table border="0" width="100%">
		<tr>
		<td nowrap="nowrap">
		<font class="FrameItemFont">

		<xsl:call-template name="printClassifierList">
			<xsl:with-param name="classes" select="$classes"></xsl:with-param>
			<xsl:with-param name="isName" select="'1'"/>
		</xsl:call-template>
	
		</font>
		</td>
		</tr>
		</table>
	</xsl:if>
	
	</body>
	</html>
</xsl:template>


<!-- Prints list of diagrams with references to class and image frames -->
<xsl:template name="printDiagramList">
	<xsl:param name="diagrams"></xsl:param>
	<xsl:for-each select="$diagrams">
		<xsl:sort select="@name"></xsl:sort>
		
		<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
		<br/>
	</xsl:for-each>
</xsl:template>

<!-- Prints list of classifiers (Interfaces in italic) refs to classFrame-->
<xsl:template name="printClassifierList">
	<xsl:param name="classes"></xsl:param>
	<xsl:param name="isName"/>
		<xsl:for-each select="$classes">
			<xsl:sort select="@name"></xsl:sort>
			
			<xsl:apply-templates select="current()" mode="HRefWithImgLoad">
				<xsl:with-param name="isName" select="$isName"/>
			</xsl:apply-templates>
			
			<br/>
		</xsl:for-each>
</xsl:template>


</xsl:stylesheet>
